/*
 * Decompiled with CFR 0.152.
 */
package com.bdlington.Catalyst.modules;

import com.bdlington.Catalyst.CatalystAddon;
import java.util.List;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1511;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;

public class CrystalMacro
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Integer> breakDelay;
    private final Setting<Double> range;
    private final Setting<Boolean> onlyWhenHoldingCrystal;
    private final Setting<Boolean> autoSwitch;
    private final Setting<Boolean> disableLogs;
    private int breakTimer;
    private boolean wasRightClicking;
    private class_243 lastPlacementPos;

    public CrystalMacro() {
        super(CatalystAddon.pvp, "Crystal Macro", "Automatically breaks crystals after placement when holding right-click.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.breakDelay = this.sgGeneral.add((Setting)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("break-delay")).description("Delay in ticks before breaking crystal after placement (1-10 ticks)")).defaultValue((Object)4)).min(1).max(10).sliderMin(1).sliderMax(10).build());
        this.range = this.sgGeneral.add((Setting)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("range")).description("Range to detect and break crystals")).defaultValue(4.5).min(1.0).max(6.0).sliderMin(1.0).sliderMax(6.0).build());
        this.onlyWhenHoldingCrystal = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-when-holding-crystal")).description("Only activate when holding end crystal")).defaultValue((Object)true)).build());
        this.autoSwitch = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("auto-switch")).description("Automatically switch to crystal when right-clicking")).defaultValue((Object)false)).build());
        this.disableLogs = this.sgGeneral.add((Setting)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("disable-logs")).description("Disable chat messages")).defaultValue((Object)true)).build());
        this.breakTimer = 0;
        this.wasRightClicking = false;
        this.lastPlacementPos = null;
    }

    public void onActivate() {
        this.breakTimer = 0;
        this.wasRightClicking = false;
        this.lastPlacementPos = null;
        if (!((Boolean)this.disableLogs.get()).booleanValue()) {
            this.info("Crystal Macro activated!", new Object[0]);
        }
    }

    public void onDeactivate() {
        this.breakTimer = 0;
        this.wasRightClicking = false;
        this.lastPlacementPos = null;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        class_239 hitResult;
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        boolean isRightClicking = this.mc.field_1690.field_1904.method_1434();
        if (((Boolean)this.onlyWhenHoldingCrystal.get()).booleanValue() && !this.isHoldingCrystal()) {
            return;
        }
        if (((Boolean)this.autoSwitch.get()).booleanValue() && isRightClicking && !this.isHoldingCrystal()) {
            this.switchToCrystal();
        }
        if (isRightClicking && !this.wasRightClicking && this.isHoldingCrystal() && (hitResult = this.mc.field_1765) != null && hitResult.method_17783() == class_239.class_240.field_1332) {
            this.lastPlacementPos = hitResult.method_17784();
            this.breakTimer = (Integer)this.breakDelay.get();
            if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                this.info("Crystal placement detected, breaking in %d ticks", new Object[]{this.breakTimer});
            }
        }
        if (this.breakTimer > 0) {
            --this.breakTimer;
            if (this.breakTimer == 0) {
                this.breakNearestCrystal();
            }
        }
        if (isRightClicking && this.isHoldingCrystal()) {
            this.breakNearbyNewestCrystal();
        }
        this.wasRightClicking = isRightClicking;
    }

    private void breakNearestCrystal() {
        if (this.lastPlacementPos == null) {
            return;
        }
        List crystals = this.mc.field_1687.method_8390(class_1511.class, new class_238(this.lastPlacementPos.method_1031(-1.0, -1.0, -1.0), this.lastPlacementPos.method_1031(1.0, 2.0, 1.0)), crystal -> crystal.method_5858((class_1297)this.mc.field_1724) <= (Double)this.range.get() * (Double)this.range.get());
        if (!crystals.isEmpty()) {
            class_1511 closest = (class_1511)crystals.get(0);
            for (class_1511 crystal2 : crystals) {
                if (!(crystal2.method_5707(this.lastPlacementPos) < closest.method_5707(this.lastPlacementPos))) continue;
                closest = crystal2;
            }
            this.attackCrystal(closest);
            this.lastPlacementPos = null;
        }
    }

    private void breakNearbyNewestCrystal() {
        List crystals = this.mc.field_1687.method_8390(class_1511.class, new class_238(this.mc.field_1724.method_19538().method_1031(-((Double)this.range.get()).doubleValue(), -((Double)this.range.get()).doubleValue(), -((Double)this.range.get()).doubleValue()), this.mc.field_1724.method_19538().method_1031(((Double)this.range.get()).doubleValue(), ((Double)this.range.get()).doubleValue(), ((Double)this.range.get()).doubleValue())), crystal -> crystal.method_5858((class_1297)this.mc.field_1724) <= (Double)this.range.get() * (Double)this.range.get());
        if (!crystals.isEmpty()) {
            class_1511 newest = (class_1511)crystals.get(0);
            for (class_1511 crystal2 : crystals) {
                if (crystal2.method_5628() <= newest.method_5628()) continue;
                newest = crystal2;
            }
            if (this.mc.field_1724.field_6012 % (2 + (int)(Math.random() * 3.0)) == 0) {
                this.attackCrystal(newest);
            }
        }
    }

    private void attackCrystal(class_1511 crystal) {
        block4: {
            if (crystal == null || crystal.method_31481()) {
                return;
            }
            try {
                class_243 crystalPos = crystal.method_19538().method_1031(0.0, (double)(crystal.method_17682() / 2.0f), 0.0);
                this.mc.field_1761.method_2918((class_1657)this.mc.field_1724, (class_1297)crystal);
                this.mc.field_1724.method_6104(class_1268.field_5808);
                if (!((Boolean)this.disableLogs.get()).booleanValue()) {
                    this.info("Attacked crystal at %.1f, %.1f, %.1f", new Object[]{crystal.method_23317(), crystal.method_23318(), crystal.method_23321()});
                }
            }
            catch (Exception e) {
                if (((Boolean)this.disableLogs.get()).booleanValue()) break block4;
                this.error("Failed to attack crystal: " + e.getMessage(), new Object[0]);
            }
        }
    }

    private boolean isHoldingCrystal() {
        if (this.mc.field_1724 == null) {
            return false;
        }
        return this.mc.field_1724.method_6047().method_7909() == class_1802.field_8301 || this.mc.field_1724.method_6079().method_7909() == class_1802.field_8301;
    }

    private void switchToCrystal() {
        if (this.mc.field_1724 == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            if (this.mc.field_1724.method_31548().method_5438(i).method_7909() != class_1802.field_8301) continue;
            this.mc.field_1724.method_31548().method_61496(i);
            if (((Boolean)this.disableLogs.get()).booleanValue()) break;
            this.info("Switched to crystal in slot %d", new Object[]{i + 1});
            break;
        }
    }
}

